#!/usr/bin/perl

# add-001.pl - insert a 001 field into a MARC record; a hack

# Eric Lease Morgan <emorgan@nd.edu>
# June 5, 2009 - first cut; rough

use strict;
use MARC::Batch;

my $file = $ARGV[ 0 ];
my $prefix = $ARGV[ 1 ];
if ( ! $file or ! $prefix ) {

	print "Usage: $0 <file> <prefix>\n";
	exit;
	
}
my $batch = MARC::Batch->new( 'USMARC', $file );
my $count = 0;
while ( my $record = $batch->next ) {

	$record->delete_field( $record->field( '001' ));
	$count++;
	$record->append_fields( MARC::Field->new( '001', $prefix . '-' . $count ));
	print $record->as_usmarc;
	
}
