#!/usr/bin/perl

# sets2gallery.pl - create index.html files of sets from flickr content

# Eric Lease Morgan <eric_morgan@infomotions.com>
# May 15, 2010 - first investigations
# May 17, 2010 - process all sets; no input required but can't make just one
# May 22, 2010 - added creation of image database to facilitate generating random image


# require
use CGI;
use LWP::UserAgent;
use strict;
use XML::XPath;

# configure
use constant GETLIST        => 'http://api.flickr.com/services/rest/?method=flickr.photosets.getList&api_key=50e083708380c01d75fb123fec320365&user_id=94959848@N00';
use constant GETINFO        => 'http://api.flickr.com/services/rest/?method=flickr.photosets.getInfo&api_key=50e083708380c01d75fb123fec320365&photoset_id=';
use constant GETPHOTOS      => 'http://api.flickr.com/services/rest/?method=flickr.photosets.getPhotos&api_key=50e083708380c01d75fb123fec320365&photoset_id=';
use constant FLICKR         => 'http://www.flickr.com/photos/infomotions/';
use constant FILESYSTEMROOT => '/disk01/www/html/main/images/';
use constant HTTPSYSTEMROOT => '/images/';
use constant IMAGEDB        => '/disk01/www/html/main/images/etc/images.db';

# build a list of all sets
my $ua       = LWP::UserAgent->new;
my $request  = HTTP::Request->new( GET => GETLIST );
my $response = $ua->request( $request );
my $parser   = XML::XPath->new( xml => $response->content );
my $nodes    = $parser->find( '//photoset' );
my @sets     = ();
foreach my $node ( $nodes->get_nodelist ) { push @sets, $node->getAttribute( 'id' ) }

# process each set
my $index    = -1;
my $imagedb  = '';
foreach my $set ( @sets) {

	# get and extract metadata
	$ua             = LWP::UserAgent->new;
	$request        = HTTP::Request->new( GET => GETINFO . $set );
	$response       = $ua->request( $request );
	$parser         = XML::XPath->new( xml => $response->content );
	my $title       = $parser->findvalue( '/rsp/photoset/title' );
	my $description = $parser->findvalue( '/rsp/photoset/description' );
	
	# echo status
	$index++;
	print "Processing set $index of $#sets ($title)...\n";
	
	# get this photo set
	$request  = HTTP::Request->new( GET => GETPHOTOS . $set );
	$response = $ua->request( $request );
	
	# process each photo
	$parser    = XML::XPath->new( xml => $response->content );
	my $cgi    = CGI->new;
	my $images = '';
	my $nodes  = $parser->find( '//photo' );
	foreach my $node ( $nodes->get_nodelist ) {
	
		# parse
		my $id     = $node->getAttribute( 'id' );
		my $title  = $node->getAttribute( 'title' );
		my $farm   = $node->getAttribute( 'farm' );
		my $server = $node->getAttribute( 'server' );
		my $secret = $node->getAttribute( 'secret' );
	
		# build image links
		my $thumb = "http://farm$farm.static.flickr.com/$server/$id" . '_' . $secret . '_s.jpg';
		my $full  = "http://farm$farm.static.flickr.com/$server/$id" . '_' . $secret . '.jpg';
		my $flickr = FLICKR . "$id/";
		
		# build list of images
		$images .= $cgi->a({ href => $full, rel => 'slideshow', title => "<a href='$flickr'>Details on Flickr</a>"}, $cgi->img({ alt => $title, src => $thumb, border => 0, hspace => 1, vspace => 1 }));

		# add a record to the image database; the use of the token is tricky
		$imagedb .= "##INDEXPAGE##\t$title\t$thumb\n";
		
	}
	
	# build html
	my $html =  &template;
	$html    =~ s/##TITLE##/$title/;
	$html    =~ s/##IMAGES##/$images/;
	$html    =~ s/##DESCRIPTION##/$description/;
	$html    =~ s/##DIRECTORY##/$set/eg;
	
	# save
	my $directory = FILESYSTEMROOT . $set;
	mkdir $directory;
	my $index = "$directory/index.html";
	open OUT, " > " . $index or die "Can't open $index: $!\n";
	print OUT $html;
	close OUT;
	
	# replace the token in each image database record; undo trickiness
	my $root =  HTTPSYSTEMROOT . $set;
	$imagedb =~ s/##INDEXPAGE##/$root/eg;
		
}

# save the image database
open OUT, " > " . IMAGEDB or die "Can't open image database: $!\n";
print OUT $imagedb;
close OUT;

# done
exit;


sub template {

	# shape of html page
	return <<EOF
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
        "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<link rel="stylesheet" type="text/css" href="http://infomotions.com/etc/css/jquery-ui.css" />
	<link rel="stylesheet" type="text/css" href="http://infomotions.com/etc/css/screen.css" media="screen" />
	<link rel="stylesheet" type="text/css" href="http://infomotions.com/etc/css/print.css" media="print" />
	<link rel="stylesheet" type="text/css" href="/etc/colorbox/colorbox.css" media="screen" />
	<script type="text/javascript" src="/etc/js/jquery-core.js"></script>
	<script type="text/javascript" src="/etc/colorbox/colorbox.js"></script>
	<script type="text/javascript">
		\$(document).ready(function(){
			\$("a[rel='slideshow']").colorbox({ slideshowAuto: false, current: "{current} of {total}", slideshowStart: 'Slideshow', slideshowStop: 'Stop', slideshow: true, transition:"elastic"});
		});
	</script>
	<title>Infomotions, Inc.</title>
</head>
<body>

	<!-- global navigation; menu bar -->
	<div id="menu" class="ui-tabs ui-widget ui-widget-content ui-corner-all">
		
			<ul id="tabs" class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
				<li id='first-tab' class="ui-state-default ui-corner-top"><a href="/">Home</a>
				<li class="ui-state-default ui-corner-top"><a href="/alex/">Alex Catalogue</a>
				<li class="ui-state-default ui-corner-top ui-tabs-selected ui-state-active"><a href="/images/">Images</a>
				<li class="ui-state-default ui-corner-top"><a href="/blog/">Blog</a>
				<li class="ui-state-default ui-corner-top"><a href="/musings/">Musings</a>
				<li class="ui-state-default ui-corner-top"><a href="/water/index.xml">Water</a>
				<li class="ui-state-default ui-corner-top"><a href="http://m.infomotions.com/">iMobile</a>
			</ul>
				
	</div>
		
	<!-- navigation -->
	<div id='navigation'>
		<div class='innertube'>
		
                <!-- logo and short -->
                <p id='navigation-logo'><img src='/logo.gif' width="44" height="44" alt='logo' /><br />
                <br />Image Gallery</p>
                
		</div>
	</div>
        
	<!-- content -->
	<div id='content'>
		<div class='innertube'>
		<h2>##TITLE##</h2>
		
		<p>##DESCRIPTION##</p>
		
		<p>##IMAGES##</p>
		
		<hr />
		<p>Creator: Eric Lease Morgan &lt;<a href="mailto:eric_morgan\@infomotions.com">eric_morgan\@infomotions.com</a>&gt;<br />
		Date created: 2001-01-01<br />
		Date updated: 2010-05-22<br />
		URL: <a href="http://infomotions.com/images/##DIRECTORY##/">http://infomotions.com/images/##DIRECTORY##/</a></p>
		</div>
	</div>
</body>
</html>
EOF

}