@rem  Placed in the public domain on 09 July 2004
@setlocal
@title Convert XML file with XSLT stylesheet.
@for /F "delims=." %%v in ('echo') do @set echo=%%v
@for %%v in (%echo%) do @set echo=%%v
@prompt $Q
@echo on


:begin
@set CurrentDir=%CD%\
@set ScriptDir=%~dp0
@set ScriptFile=%~nx0
@set ScriptName=%~n0
@set NowDATE=%DATE%
@set NowTIME=%TIME%
@if "%NowDATE%" == "" then for /F "usebackq" %%d in (`date /t`) do @set NowDATE=%%d
@if "%NowTIME%" == "" then for /F "usebackq" %%t in (`time /t`) do @set NowTIME=%%t
@set NowDT=%NowDATE% %NowTIME%
@for /F "tokens=1-7 delims=:/- " %%a in ("%NowDT%") do @set NowDT=%%a%%b%%c%%d%%e%%f
@set NowDateTime=%NowDT:~0,-1%
@for /F "tokens=1-4 delims=:/- " %%a in ("%NowDATE%") do @set NowDate=%%a-%%b-%%c
@for /F "tokens=1-4 delims=:/- " %%a in ("%NowTIME%") do @set NowTime=%%a:%%b:%%c
@goto :param


:param
@if "%~1" == ""  @goto :usage
@if "%~2" == ""  @goto :usage
@goto :runConvert


:runConvert
@call :runXsl "%~1" "%~2"
@goto :end


:runXsl
@call :runSaxon6 %*
@goto :EOF


:runAltova
altovaxslt -xml "%~1" -xsl "%ScriptDir%%ScriptName%.xsl" -out "%~2"
@goto :EOF


:runMSXSL
msxsl "%~1" "%ScriptDir%%ScriptName%.xsl" -o "%~2" -u 4.0
@goto :EOF


:runNXSLT
nxslt "%~1" "%ScriptDir%%ScriptName%.xsl" -o "%~2"
@goto :EOF


:runSaxonInstant
saxon -o "%~2" "%~1" "%ScriptDir%%ScriptName%.xsl"
@goto :EOF


:runSaxon6
java -Xmx1024m -Xms1024m com.icl.saxon.StyleSheet -o "%~2" "%~1" "%ScriptDir%%ScriptName%.xsl"
@goto :EOF


:runSaxon7
java -Xmx1024m -Xms1024m net.sf.saxon.Transform -o "%~2" "%~1" "%ScriptDir%%ScriptName%.xsl"
@goto :EOF


:runSaxon8
java -Xmx1024m -Xms1024m net.sf.saxon.Transform -o "%~2" "%~1" "%ScriptDir%%ScriptName%.xsl"
@goto :EOF


:runXalanJ
java -Xmx1024m -Xms1024m org.apache.xalan.xslt.Process -flavor s2s -in "%~1" -xsl "%ScriptDir%%ScriptName%.xsl" -out "%~2"
@goto :EOF


:usage
@echo.Usage %ScriptFile% in-file out-file
@goto :end


:now
@set nowDate=%DATE%
@set nowTime=%TIME%
@if "%nowDate%" == "" then for /F "usebackq" %%d in (`date /t`) do @set nowDate=%%d
@if "%nowTime%" == "" then for /F "usebackq" %%t in (`time /t`) do @set nowTime=%%t
@echo %nowDate% %nowTime% -- %*
@goto :EOF


:time
@echo.
@call :now Started
@call %*
@call :now Finished
@goto :EOF


:end
@echo %echo%
@prompt
@title Command Prompt
@endlocal
