<?xml version="1.0"?>

<!--
  Placed in the public domain 09 July 2004.
  -->

<xsl:transform version="1.0"
  exclude-result-prefixes="msext msxsl xsd xsi xsl"

  xmlns:xsd="http://www.w3.org/2001/XMLSchema"
  xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"

  xmlns:msext="http://msdn.microsoft.com/scripting"
  xmlns:msxsl="urn:schemas-microsoft-com:xslt"
>
  <!--
    Convert errors in EAD XML files.
    -->


  <!-- Output: define output document characteristics -->

    <xsl:output method="xml" version="1.0"
      media-type="text/xml" encoding="utf-8"
      omit-xml-declaration="no" indent="no"
    />

    <xsl:strip-space elements="*"/>


  <!-- Global: parameters -->


  <!-- Global: documents -->

    <xsl:variable name="this.doc" select="document('')"/>


  <!-- Global: document keys -->


  <!-- Global: document namespaces -->

    <xsl:variable name="xmlns."        select="$this.doc/*[1]/namespace::*[name() = '']"/>
    <xsl:variable name="xmlns.xsd"     select="$this.doc/*[1]/namespace::*[name() = 'xsd']"/>
    <xsl:variable name="xmlns.xsi"     select="$this.doc/*[1]/namespace::*[name() = 'xsi']"/>
    <xsl:variable name="xmlns.xsl"     select="$this.doc/*[1]/namespace::*[name() = 'xsl']"/>
    <xsl:variable name="xmlns.msext"     select="$this.doc/*[1]/namespace::*[name() = 'msext']"/>
    <xsl:variable name="xmlns.msxsl"     select="$this.doc/*[1]/namespace::*[name() = 'msxsl']"/>


  <!-- Global: variables -->

    <xsl:variable name="Indent"   select="concat('&#32;','&#32;')"/>
    <xsl:variable name="Indent.0" select="string('')"/>
    <xsl:variable name="Indent.1" select="concat($Indent.0,$Indent)"/>
    <xsl:variable name="Indent.2" select="concat($Indent.1,$Indent)"/>
    <xsl:variable name="Indent.3" select="concat($Indent.2,$Indent)"/>
    <xsl:variable name="Indent.4" select="concat($Indent.3,$Indent)"/>
    <xsl:variable name="Indent.5" select="concat($Indent.4,$Indent)"/>
    <xsl:variable name="Indent.6" select="concat($Indent.5,$Indent)"/>
    <xsl:variable name="Indent.7" select="concat($Indent.6,$Indent)"/>
    <xsl:variable name="Indent.8" select="concat($Indent.7,$Indent)"/>
    <xsl:variable name="Indent.9" select="concat($Indent.8,$Indent)"/>

    <xsl:variable name="NewLine"   select="string('&#10;')"/>
    <xsl:variable name="NewLine.0" select="string('')"/>
    <xsl:variable name="NewLine.1" select="concat($NewLine.0,$NewLine)"/>
    <xsl:variable name="NewLine.2" select="concat($NewLine.1,$NewLine)"/>
    <xsl:variable name="NewLine.3" select="concat($NewLine.2,$NewLine)"/>
    <xsl:variable name="NewLine.4" select="concat($NewLine.3,$NewLine)"/>
    <xsl:variable name="NewLine.5" select="concat($NewLine.4,$NewLine)"/>
    <xsl:variable name="NewLine.6" select="concat($NewLine.5,$NewLine)"/>
    <xsl:variable name="NewLine.7" select="concat($NewLine.6,$NewLine)"/>
    <xsl:variable name="NewLine.8" select="concat($NewLine.7,$NewLine)"/>
    <xsl:variable name="NewLine.9" select="concat($NewLine.8,$NewLine)"/>

    <xsl:variable name="Quote">
      <xsl:text>"</xsl:text>
    </xsl:variable>


  <!-- Template: String.Repeat -->

    <xsl:template name="String.Repeat">
      <xsl:param name="text"  select="string('')"/>
      <xsl:param name="count" select="number(0)"/>

      <!-- Repeating a string zero times will result in an empty string -->

        <xsl:if test="number($count) &gt; 0">

          <xsl:value-of select="$text"/>

          <xsl:call-template name="String.Repeat">
            <xsl:with-param name="text"  select="$text"/>
            <xsl:with-param name="count" select="number($count) - 1"/>
          </xsl:call-template>

        </xsl:if>

    </xsl:template>


  <!-- Template: Comments -->

    <xsl:template name="Comments" match="comment()">
      <xsl:copy-of select="."/>
    </xsl:template>


  <!-- Template: Elements -->

    <xsl:template name="Elements" match="*">

      <!-- Requirement: remove admininfo element and its children -->

      <xsl:if test="name() != 'admininfo'">

        <!-- calculate pretty formatting indent value -->

        <xsl:variable name="indent">
          <xsl:call-template name="String.Repeat">
            <xsl:with-param name="text"  select="$Indent"/>
            <xsl:with-param name="count" select="count(ancestor::*) * number(not(preceding-sibling::text()))"/>
          </xsl:call-template>
        </xsl:variable>

        <!-- calculate pretty formatting newline value -->

        <xsl:variable name="newline">
          <xsl:choose>

            <!-- Use a different value for the document node -->

            <xsl:when test=". = /*[1]">
              <xsl:value-of select="$NewLine.2"/>
            </xsl:when>

            <!-- Use a different value for mixed content nodes -->

            <xsl:when test="preceding-sibling::text()">
              <xsl:value-of select="$NewLine.0"/>
            </xsl:when>

            <!-- Use the same value for document node children -->

            <xsl:otherwise>
              <xsl:value-of select="$NewLine.1"/>
            </xsl:otherwise>

          </xsl:choose>
        </xsl:variable>

        <!-- Output pretty formatting for beginning tags -->

        <xsl:value-of select="concat($newline,$indent)"/>

        <!-- Copy the element -->

        <xsl:copy>

          <xsl:choose>

            <!-- Requirement: change the langencoding attribute for the eadheader element -->

            <xsl:when test="name() = 'eadheader'">

              <!-- Process attributes in document order -->

              <xsl:for-each select="@*">
                <xsl:choose>

                  <xsl:when test="name() = 'langencoding'">
                    <xsl:attribute name="{name()}">
                      <xsl:value-of select="string('ISO639-2')"/>
                    </xsl:attribute>
                  </xsl:when>

                  <xsl:otherwise>
                    <xsl:copy-of select="."/>
                  </xsl:otherwise>

                </xsl:choose>
              </xsl:for-each>

            </xsl:when>

            <!-- Requirement: remove the langmaterial and legalstatus attribute from the archdesc element -->

            <xsl:when test="name() = 'archdesc'">
              <xsl:copy-of select="@*[name() != 'langmaterial' and name() != 'legalstatus']"/>
            </xsl:when>

            <!-- Otherwise just copy the attribute -->

            <xsl:otherwise>
              <xsl:copy-of select="@*"/>
            </xsl:otherwise>

          </xsl:choose>

          <!-- Continue processing nodes in the document -->

          <xsl:apply-templates/>

          <!-- Output pretty formatting for ending tags with non-mixed content -->

          <xsl:if test="*[1] and not(text()[1])">
            <xsl:value-of select="concat($NewLine.1,$indent)"/>
          </xsl:if>

        </xsl:copy>

      </xsl:if>

    </xsl:template>


  <!-- Template: Root.PI -->

    <xsl:template name="Root.PI" match="processing-instruction()">

      <xsl:choose>

        <!-- Requirement: change the href text for the xml-stylesheet processing instruction -->

        <xsl:when test="name() = 'xml-stylesheet'">
          <xsl:processing-instruction name="{name()}">
            <xsl:value-of select="substring-before(.,' href=')"/>
            <xsl:value-of select="concat(' href=',$Quote,'ead2html.xsl',$Quote)"/>
          </xsl:processing-instruction>
        </xsl:when>

        <!-- Otherwise just copy the processing instruction -->

        <xsl:otherwise>
          <xsl:copy-of select="."/>
        </xsl:otherwise>

      </xsl:choose>

    </xsl:template>


  <!-- Template: Root.CommentsAndPI -->

    <xsl:template name="Root.CommentsAndPI">

      <!-- Pretty format document level comments and processing instructions -->

      <xsl:if test="position() = 1">
        <xsl:value-of select="concat($NewLine.1,$Indent.0)"/>
      </xsl:if>

      <xsl:choose>

        <xsl:when test="self::processing-instruction()">
          <xsl:value-of select="concat($NewLine.1,$Indent.0)"/>

          <xsl:apply-templates/>
        </xsl:when>

        <xsl:when test="self::comment() and contains(.,$NewLine)">
          <xsl:value-of select="concat($NewLine.1,$Indent.0)"/>

          <xsl:copy-of select="."/>
        </xsl:when>

        <xsl:when test="self::comment() and preceding-sibling::node()[1]/self::processing-instruction()">
          <xsl:value-of select="concat($NewLine.1,$Indent.0)"/>

          <xsl:copy-of select="."/>
        </xsl:when>

        <xsl:when test="self::comment() and contains(preceding-sibling::node()[1]/self::comment(),$NewLine)">
          <xsl:value-of select="concat($NewLine.1,$Indent.0)"/>

          <xsl:copy-of select="."/>
        </xsl:when>

        <xsl:when test="self::comment() and not(preceding-sibling::node())">
          <xsl:value-of select="concat($NewLine.1,$Indent.0)"/>

          <xsl:copy-of select="."/>
        </xsl:when>

        <xsl:when test="self::comment() and preceding-sibling::node()[1] = /*[1]">
          <xsl:value-of select="concat($NewLine.1,$Indent.0)"/>

          <xsl:copy-of select="."/>
        </xsl:when>

        <xsl:otherwise>
          <xsl:copy-of select="."/>
        </xsl:otherwise>

      </xsl:choose>

      <xsl:if test="position() != last()">
        <xsl:value-of select="concat($NewLine.1,$Indent.0)"/>
      </xsl:if>

    </xsl:template>


  <!-- Template: Root -->

    <xsl:template name="Root" match="/">

      <!-- Ensure that these are really EAD records -->

      <xsl:if test="*[1]/self::ead">

        <!-- Process comments and processing instructions before document element -->

        <xsl:for-each select="(comment() | processing-instruction())[following-sibling::*[1]]">
          <xsl:call-template name="Root.CommentsAndPI"/>
        </xsl:for-each>

        <!-- Process document element and children -->

        <xsl:apply-templates/>

        <!-- Process comments and processing instructions after document element -->

        <xsl:for-each select="(comment() | processing-instruction())[preceding-sibling::*[1]]">
          <xsl:call-template name="Root.CommentsAndPI"/>
        </xsl:for-each>

      </xsl:if>

      <!-- Output pretty formatting -->

      <xsl:value-of select="concat($NewLine.1,$Indent.0)"/>

    </xsl:template>


</xsl:transform>
