#!/usr/bin/perl

# marc2mylibrary.pl - import a set of MARC records into MyLibrary; a simple import

# Eric Lease Morgan (eric_morgan@infomotions.com)
# February 21, 2006


# get the input
my $marc_records = shift @ARGV;

# check for input
if (! $marc_records) {

	# print help text and quit
	print "Usage: $0 [file] where [file] is the name of a file containing USMARC records.\n";
	exit;
	
}

# use the necessary module
use lib '../lib';
use MyLibrary::Core;
use MARC::Batch;
use strict;

# define constants
use constant SUBJECTID      => 55;
use constant FORMATID       => 3;
use constant LOCATIONTYPEID => 9;

# create a batch object with the input file
my $batch = MARC::Batch->new('USMARC', $marc_records);

# process every record in the object
while (my $record = $batch->next()) {
	
	# get the author
	my $author   = $record->subfield('100', 'a');
	$author =~ s/\[from old catalog\]//;
	$author =~ s/\.$//;
	$author =~ s/,$//;
	
	# now title
	my $title    = $record->subfield('245', 'a');
	$title =~ s/ \/$//;
	$title =~ s/\.$//;
	$title =~ s/ ://;
	$title =~ s/\[from old catalog\]//;

	# call number
	my $call_number = $record->subfield('050', 'a') . ' ' . $record->subfield('050', 'b');
	
	# get the subject(s)
	my @subjects = $record->field('650'); 
	my $subjects;
	foreach my $subject (@subjects) {
	
		# build the subjects
		$subjects .= $subject->as_string() . ' ';
	
	}
	$subjects =~ s/\[from old catalog\]//g;
	$subjects =~ s/\. /; /g;
	
	# output only records with all elements; cheating?
	if ($author && $title && $subjects && $call_number) {
	
		print "      author: $author\n";
		print "       title: $title\n";
		print "    subjects: $subjects\n";
		print " call number: $call_number\n";
	
		# make things a bit pretty
		print "\n";
		
		# create a resource object
		my $resource = MyLibrary::Resource->new;
		
		# give it characteristics
		$resource->name($title);
		$resource->creator($author);
		$resource->note($subjects);
		$resource->related_terms( new => [SUBJECTID, FORMATID] );
		$resource->add_location(location => $call_number, location_type => LOCATIONTYPEID);
		
		# save
		if ($resource->commit) { print "Saved.\n" }

	}
	
} 

# done
exit;
