#!/usr/bin/perl

# search.pl - search the index of resources

# Eric Lease Morgan <emorgan@nd.edu>

# 2006-01-12 - added pod
# 2004-10-11 - first cut

=head1 NAME

search.pl - search an index of MyLibrary resources

=head1 DESCRIPTION

Use this script to search the index created by the indexing script (./index-resources.pl). The script accepts any queries understood by swish-e. Examples include:

=over

=item *

foo

=item *

foo*

=item *

foo and bar

=item *

foo or bar

=item *

(foo or bar) not foobar

=item *

title=foobar

=back

You will have to become familiar with the swish-e searching documentation in order to learn the full expressiveness of the query language.

After queries are input, the index is searched, and results are returned.

=head1 SEE ALSO

index-resources.cfg, resources2swish.pl, search.pl

=head1 AUTHOR

Eric Lease Morgan

=cut

# require the necessary modules/libraries
use lib '../lib/';
use MyLibrary::Resource;
use SWISH::API;
use strict;
require './subroutines.pl';

my $INDEX = '../etc/portal.idx';

print "Enter a query. "; chop (my $query = <STDIN>);

my $swish = SWISH::API->new($INDEX);
my $results = $swish->Query($query);
my $hits = $results->Hits;

if ($hits) {

	print "Your search ($query) returned $hits hit(s).\n";
	while (my $result = $results->NextResult) {
	
		&listOneResource ($result->Property ("swishdocpath"));
	
	}

}

else {

	print "No hits. Sorry.\n";
	
}