#!/usr/bin/perl

# articles.cgi - a Web interface for managing the articles of Musings

# Eric Lease Morgan <eric_morgan@infomotions.com>

# 2004-11-01 - first cust


# require the necessary modules
use lib '../lib';
use CGI qw/:standard/;
use CGI::Carp qw(fatalsToBrowser);
use Musings::Article;
use Musings::Author;
use Musings::Stylesheet;
use Musings::Subject;
use Musings::Template;
use XML::LibXML;
use XML::LibXSLT;
use DateTime;
use strict;
require 'subroutines.pl';

# define the htdocs root
use constant ROOT => '/usr/local/apache/htdocs';
use constant HOST => 'http://infomotions.com';

# initialize two global variables
my $cgi = CGI->new;
my $html;

# branch according to the input
if (! $cgi->param('cmd')) { &home }
elsif ($cgi->param('cmd') eq 'create')        { &create }
elsif ($cgi->param('cmd') eq 'find')          { &find }
elsif ($cgi->param('cmd') eq 'edit')          { &edit }
elsif ($cgi->param('cmd') eq 'build')         { &build }
elsif ($cgi->param('cmd') eq 'build_all')     { &build_all }
elsif ($cgi->param('cmd') eq 'transform')     { &transform }
elsif ($cgi->param('cmd') eq 'transform_all') { &transform_all }
elsif ($cgi->param('cmd') eq 'delete')        { &delete }
else  {$html = $cgi->p('Unknown command. Call Eric.') }

# quit
&gracefulExit;


sub home {

	# build a simple home page
	$html  = $cgi->h1('Manage articles');
	$html .= $cgi->p('Use this script to create, edit, and delete Musings articles.');

}


sub create {

	# initialize the output
	$html = $cgi->h1('Create');
	
	# branch according to the input
	if (! $cgi->param('button')) {
		
		# get the authors
		my ($author_values, $author_labels) = &get_all_authors;
		
		# get the subjects
		my ($subject_values, $subject_labels) = &get_all_subjects;
		
		# get the templates
		my ($template_values, $template_labels) = &get_all_templates;
		
		# creat a change log
		my $changes = "<change>\n<date>" . DateTime->now->ymd . "</date>\n<respStmt>\n<name>Eric Lease Morgan</name>\n</respStmt>\n<item>initial TEI encoding</item>\n</change>";
		
		# build the form
		$html .= $cgi->p('Use this form to create an article.');
		$html .= $cgi->start_form(-method => 'post', -action => $cgi->script_name);
		$html .= $cgi->hidden(-name => 'cmd', -value => 'create');
		$html .= table({-border => 0}, Tr({-align => 'left', -valign => 'top'},
						[
							th(['Item', 'Value']),
							td(['Path', $cgi->textfield(-name => 'path', -size => 50)]),
							td(['Filename', $cgi->textfield(-name => 'filename', -size => 50)]),
							td(['Template', $cgi->popup_menu(-name => 'template_id', -values => $template_labels)]),
							td(['Title', $cgi->textfield(-name => 'title', -size => 50)]),
							td(['Author(s)', $cgi->scrolling_list(-name=>'author_ids', -values => [@{$author_values}], -size => 3, -multiple => 'true', -labels => $author_labels)]),
							td(['Date created', $cgi->textfield(-name => 'date', -values => DateTime->now->ymd, -size => 10, -maxlength => 10)]),
							td(['Abstract', $cgi->textarea(-name => 'note', -rows => 6, -columns => 50)]),
							td(['Source', $cgi->textarea(-name => 'source', -rows => 6, -columns => 50)]),
							td(['Changes', $cgi->textarea(-name => 'changes', -default => $changes, -rows => 6, -columns => 50)]),
							td(['Content', $cgi->textarea(-name => 'content', -rows => 12, -columns => 50)]),
							td(['Subject(s)', $cgi->scrolling_list(-name=>'subject_ids', -values => [@{$subject_values}], -size => 10, -multiple => 'true', -labels => $subject_labels)]),
							td([''    , $cgi->submit(-name => 'button', -value => 'Create')])
						]
					)
				 );
		$html .= $cgi->endform;
    
    }
    
    else {
    
    	# create an object, fill it, and save
    	my $article = Musings::Article->new;
    	$article->article_title($cgi->param('title'));
    	$article->article_date($cgi->param('date'));
    	$article->article_changes($cgi->param('changes'));
    	$article->article_note($cgi->param('note'));
    	$article->article_path($cgi->param('path'));
    	$article->article_content($cgi->param('content'));
    	$article->article_filename($cgi->param('filename'));
    	$article->article_source($cgi->param('source'));
    	$article->author_ids($cgi->param('author_ids'));
    	$article->subject_ids($cgi->param('subject_ids'));
    	$article->template_id($cgi->param('template_id'));
		$article->commit;
				
		# echo the results
		my $link = $cgi->script_name. '?cmd=build&button=Build&id=' . $article->article_id;
		$html .= $cgi->p("Done. Now <a href='$link'>build</a>.");
		$html .= $cgi->ul(&list_one_article(id => $article->article_id, style => 'full'));
    
    }
    
}


sub find {

	# initialize the output
	$html  = $cgi->h1('All articles');
	$html .= $cgi->p('This is a list of all the articles:');
	
	# get all the articles, build a list, and display it
	my @articles = Musings::Article->get_articles(sort => 'name');
	my $items;
	foreach (@articles) { $items .= $cgi->li($_->article_title, ' (' . $_->article_id . ')') }
	$html .= $cgi->ul($items);
	
}


sub edit {

	# initialize the output and a button
	$html = $cgi->h1('Edit articles');
	my $submit .= $cgi->submit(-name => 'button', -value => 'Edit');
	
	# branch according to the input
	if (! $cgi->param('button')) {
	
		# create a hash of articles; needs to be sorted
		my @articles = Musings::Article->get_articles(sort => 'name');
		my %articles;
		foreach (@articles) { $articles{$_->article_id} = $_->article_title }
	
		# display a form
		$html .= $cgi->p('Select a article to edit');
		$html .= $cgi->start_form(-method => 'post', -action => $cgi->script_name);
		$html .= $cgi->hidden(-name => 'cmd', -value => 'edit');
		$html .= $cgi->popup_menu(-name => 'id', -values => \%articles);
		$html .= $submit;			 
		$html .= $cgi->endform;

	}
	
	elsif (! $cgi->param('title')) {
	
    	# create an object based on the input, and create form parts
    	my $article = Musings::Article->new(id => $cgi->param('id'));
    	
		# get the authors
		my ($author_values, $author_labels) = &get_all_authors;
		
		# get the subjects
		my ($subject_values, $subject_labels) = &get_all_subjects;
		
		# get the templates
		my ($template_values, $template_labels) = &get_all_templates;
		
		# display an edit form
		$html .= $cgi->p('Use this form to edit a article.');
		$html .= $cgi->start_form(-method => 'post', -action => $cgi->script_name);
		$html .= $cgi->hidden(-name => 'cmd', -value => 'edit');
		$html .= $cgi->hidden(-name => 'id', -value => $article->article_id);
		$html .= table({-border => 0},
					Tr({-align => 'left', -valign => 'top'},
						[
							th(['Item', 'Value']),
							td(['ID', $article->article_id]),
							td(['Path', $cgi->textfield(-name => 'path', -value => $article->article_path, -size => 50)]),
							td(['Filename', $cgi->textfield(-name => 'filename', -value => $article->article_filename, -size => 50)]),
							td(['Template', $cgi->popup_menu(-name => 'template_id', -values => $template_labels, -default => $article->template_id)]),
							td(['Title', $cgi->textfield(-name => 'title', -value => $article->article_title, -size => 50)]),
							td(['Author(s)', $cgi->scrolling_list(-name=>'author_ids', -values => [@{$author_values}], -size => 3, -default => [$article->author_ids], -multiple => 'true', -labels => $author_labels)]),
							td(['Date created', $cgi->textfield(-name => 'date', -value => $article->article_date, -size => 10, -maxlength => 10)]),
							td(['Abstract', $cgi->textarea(-name => 'note', -value => $article->article_note, -rows => 6, -columns => 50)]),
							td(['Source', $cgi->textarea(-name => 'source', -value => $article->article_source, -rows => 6, -columns => 50)]),
							td(['Changes', $cgi->textarea(-name => 'changes', -value => $article->article_changes, -rows => 6, -columns => 50)]),
							td(['Content', $cgi->textarea(-name => 'content', -value => $article->article_content, -rows => 12, -columns => 50)]),
							td(['Subject(s)', $cgi->scrolling_list(-name=>'subject_ids', -values => [@{$subject_values}], -size => 10, -default => [$article->subject_ids], -multiple => 'true', -labels => $subject_labels)]),
							td([''    , $submit])
						]
					)
				 );
		$html .= $cgi->endform;
    
    }
    
	else {

		# create and object, fill it, and save
		my $article = Musings::Article->new(id => $cgi->param('id'));
    	$article->article_title($cgi->param('title'));
    	$article->article_date($cgi->param('date'));
    	$article->article_changes($cgi->param('changes'));
    	$article->article_note($cgi->param('note'));
    	$article->article_path($cgi->param('path'));
    	$article->article_content($cgi->param('content'));
    	$article->article_filename($cgi->param('filename'));
    	$article->article_source($cgi->param('source'));
    	$article->author_ids($cgi->param('author_ids'));
    	$article->subject_ids($cgi->param('subject_ids'));
    	$article->template_id($cgi->param('template_id'));
		$article->commit;
		
		# echo the result
		my $link = $cgi->script_name. '?cmd=build&button=Build&id=' . $article->article_id;
		$html .= $cgi->p("Done. Now <a href='$link'>build</a>.");
		$html .= $cgi->ul(&list_one_article(id => $article->article_id, style => 'full'));
    
    }

}


sub build {

	# initialize the output and a button
	$html = $cgi->h1('Build articles');
	my $submit .= $cgi->submit(-name => 'button', -value => 'Build');
	
	# branch according to the input
	if (! $cgi->param('button')) {
	
		# create a hash of articles; needs to be sorted
		my @articles = Musings::Article->get_articles(sort => 'name');
		my %articles;
		foreach (@articles) { $articles{$_->article_id} = $_->article_title }
	
		# display a form
		$html .= $cgi->p('Select an article to build');
		$html .= $cgi->start_form(-method => 'post', -action => $cgi->script_name);
		$html .= $cgi->hidden(-name => 'cmd', -value => 'build');
		$html .= $cgi->popup_menu(-name => 'id', -values => \%articles);
		$html .= $submit;			 
		$html .= $cgi->endform;

	}
	
	else {
	
		# build one
		my $article = Musings::Article->new(id => $cgi->param('id'));
		my $raw_link = &build_one_article($article);
		my $transform_link = $cgi->script_name. '?cmd=transform&id=' . $article->article_id;

		#  done
		$html .= $cgi->p("Done. See: $raw_link.");
		$html .= $cgi->p("Now <a href='$transform_link'>transform</a>.");
		
	}

}


sub build_all {

	$html = $cgi->h1('Build all articles');
	
	if (! $cgi->param('button')) {
	
		# display a confirmation
		$html .= $cgi->p('Do you want to build all the articles now?');
		$html .= $cgi->start_form(-method => 'post', -action => $cgi->script_name);
		$html .= $cgi->hidden(-name => 'cmd', -value => 'build_all');
		$html .= $cgi->submit(-name => 'button', -value => 'yes', -label => 'Yes');
		$html .= ' ';
		$html .= $cgi->submit(-name => 'button', -value => 'no', -label => 'No');		 
		$html .= $cgi->endform;
 
	}
	
	elsif ($cgi->param('button') eq 'Yes') { 
	
		my @articles = Musings::Article->get_articles;
		my $list;
		foreach (@articles) { $list .= $cgi->li(&build_one_article($_)) }
		$html .= $cgi->p('Done. See:');
		$html .= $cgi->ul($list);
			
	}
	
	else { $html .= $cgi->p('Building was aborted. Thank you for using Musings.pm.') }
	
}



sub transform {

	# initialize the output and a button
	$html = $cgi->h1('Transform one article');
	my $submit .= $cgi->submit(-name => 'button', -value => 'Transform');
	
	# branch according to the input
	if (! $cgi->param('button')) {
	
		# create a hash of articles; needs to be sorted
		my @articles = Musings::Article->get_articles(sort => 'name');
		my %articles;
		foreach (@articles) { $articles{$_->article_id} = $_->article_title }
	
		# create a hash of stylesheets; needs to be sorted
		my @stylesheets = Musings::Stylesheet->get_stylesheets(sort => 'name');
		my %stylesheets;
		foreach (@stylesheets) { $stylesheets{$_->stylesheet_id} = $_->stylesheet_name }
	
		# display a form
		$html .= $cgi->p('Select an article to transform as well as a stylesheet, and enter file name.');
		$html .= $cgi->start_form(-method => 'post', -action => $cgi->script_name);
		$html .= $cgi->hidden(-name => 'cmd', -value => 'transform');
		$html .= $cgi->popup_menu(-name => 'article_id', -values => \%articles, -default => $cgi->param('id'));
		$html .= ' ';
		$html .= $cgi->popup_menu(-name => 'stylesheet_id', -values => \%stylesheets);
		$html .= ' ';
		$html .= $cgi->textfield(-name => 'filename', -value => 'index.shtml');
		$html .= ' ';
		$html .= $submit;			 
		$html .= $cgi->endform;

	}
	
	else {
			
		# transform one
		my $link = &transform_one_article(ROOT, $cgi->param('filename'), Musings::Stylesheet->new(id => $cgi->param('stylesheet_id')), Musings::Article->new(id => $cgi->param('article_id')));
		
		my $edit_link = $cgi->script_name. '?cmd=edit&button=Edit&id=' . $cgi->param('article_id');

		# done
		$html .= $cgi->p("Done. See: $link");
		$html .= $cgi->p("Now <a href='$edit_link'>edit</a>.");
		
	}

}


sub transform_all {

	# initialize the output and a button
	$html = $cgi->h1('Transform all articles');
	my $submit .= $cgi->submit(-name => 'button', -value => 'Transform');
	
	# branch according to the input
	if (! $cgi->param('button')) {
		
		# create a hash of stylesheets; needs to be sorted
		my @stylesheets = Musings::Stylesheet->get_stylesheets(sort => 'name');
		my %stylesheets;
		foreach (@stylesheets) { $stylesheets{$_->stylesheet_id} = $_->stylesheet_name }
	
		# display a form
		$html .= $cgi->p('Select a stylesheet and enter file name.');
		$html .= $cgi->start_form(-method => 'post', -action => $cgi->script_name);
		$html .= $cgi->hidden(-name => 'cmd', -value => 'transform_all');
		$html .= $cgi->popup_menu(-name => 'stylesheet_id', -values => \%stylesheets);
		$html .= ' ';
		$html .= $cgi->textfield(-name => 'filename', -value => 'index.shtml');
		$html .= ' ';
		$html .= $submit;			 
		$html .= $cgi->endform;

	}
	
	else {
			
		# get all the articles and transform them
		my @articles = Musings::Article->get_articles;
		my $list;
		foreach (@articles) { $list .= $cgi->li(&transform_one_article(ROOT, $cgi->param('filename'), Musings::Stylesheet->new(id => $cgi->param('stylesheet_id')), $_)) }
		
		# done
		$html .= $cgi->p('Done. See:');
		$html .= $cgi->ul($list);
		
	}

}


sub delete {

	# initialize the output
	$html = $cgi->h1('Delete articles');
	
	# branch according to the input
	if (! $cgi->param('button')) {
	
		# build of hash of all articles; needs to be sorted
		my @articles = Musings::Article->get_articles(sort => 'name');
		my %articles;
		foreach (@articles) { $articles{$_->article_id} = $_->article_title }

		# display a pop-up list of articles
		$html .= $cgi->p('Select an article to delete:');
		$html .= $cgi->start_form(-method => 'post', -action => $cgi->script_name);
		$html .= $cgi->hidden(-name => 'cmd', -value => 'delete');
		$html .= $cgi->popup_menu(-name => 'id', -values => \%articles);
		$html .= $cgi->submit(-name => 'button', -value => 'delete', -label => 'Delete');		 
		$html .= $cgi->endform;

	}
	
	elsif ($cgi->param('button') eq 'Delete') {
    
    	# create an object based on input
    	my $article = Musings::Article->new(id => $cgi->param('id'));
    	
		# display a confirmation
		$html .= $cgi->p('Are you sure you want to delete the article named <b>' . $article->article_title . '</b>?');
		$html .= $cgi->start_form(-method => 'post', -action => $cgi->script_name);
		$html .= $cgi->hidden(-name => 'cmd', -value => 'delete');
		$html .= $cgi->hidden(-name => 'id', -value => $article->article_id);
		$html .= $cgi->submit(-name => 'button', -value => 'yes', -label => 'Yes');
		$html .= ' ';
		$html .= $cgi->submit(-name => 'button', -value => 'no', -label => 'No');		 
		$html .= $cgi->endform;
    
    }
    
    elsif ($cgi->param('button') eq 'Yes') {
    
    	# delete the article; do the work and echo the result
    	my $article = Musings::Article->new(id => $cgi->param('id'));
    	$article->delete;
    	$html .= $cgi->p('The article ' . $article->article_title . ' has been deleted.');
    
    }
    
    elsif ($cgi->param('button') eq 'No') {
    
    	# abort
    	my $article = Musings::Article->new(id => $cgi->param('id'));
    	$html .= $cgi->p('The article ' . $article->article_title . ' has <b>not</b> been deleted.');

    }
    
}


sub gracefulExit {

	# output the 'magic line', a standard header, the content, and a standard footer, then done
	print $cgi->header;
	print &header;
	print $html;
	print &footer;
	exit;

}


sub header {

	# get the value of this script
	my $script = $cgi->script_name;
	
	# return a standard html page; notice the stylesheet
	return <<EOH;
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<title>Manage articles</title>
		<link rel='stylesheet' href='style.css' type='text/css' />
	</head>
	<body>
		<div id="navcontainer">
			<ul id="navlist">
				<li><a href="home.cgi">Home</a></li>
				<li><a href="authors.cgi">Authors</a></li>
				<li><a href="subjects.cgi">Subjects</a></li>
				<li><a href="templates.cgi">Templates</a></li>
				<li><a href="stylesheets.cgi">Stylesheets</a></li>
				<li><a href="articles.cgi" id="current">Articles</a></li>
			</ul>
		</div>
	
		<div class='menu'>
			<p><b><a href="$script">Manage articles</a></b></p>
			<a href="$script?cmd=create">Create</a><br />
			<a href="$script?cmd=find">Find all</a><br />
			<a href="$script?cmd=edit">Edit</a><br />
			<br />
			<a href="$script?cmd=build">Build one</a><br />
			<a href="$script?cmd=build_all">Build all</a><br />
			<br />
			<a href="$script?cmd=transform">Transform one</a><br />
			<a href="$script?cmd=transform_all">Transform all</a><br />
			<br />
			<a href="$script?cmd=delete">Delete</a><br />
			<br />
		</div>
		
		<div class='content'>
EOH

}
