#!/usr/bin/perl

# subjects.cgi - a Web interface for managing Musings subject terms

# Eric Lease Morgan <eric_morgan@infomotions.com>

# 2004-10-31 - first cust


# require the necessary modules
use lib '../lib';
use CGI qw/:standard/;
use CGI::Carp qw(fatalsToBrowser);
use Musings::Subject;
use strict;
require 'subroutines.pl';

# initialize two global variables
my $cgi = CGI->new;
my $html;

# branch according to the input
if (! $cgi->param('cmd')) { &home }
elsif ($cgi->param('cmd') eq 'create')  { &create }
elsif ($cgi->param('cmd') eq 'find') { &find }
elsif ($cgi->param('cmd') eq 'edit')    { &edit }
elsif ($cgi->param('cmd') eq 'delete')  { &delete }
else { $html = $cgi->p("Unknown command. Call Eric") }

# quit
&gracefulExit;


sub home {

	# build a simple home page
	$html  = $cgi->h1('Manage subjects');
	$html .= $cgi->p('Use this script to create, edit, and delete Musings subjects.');

}


sub create {

	# initialize the output
	$html = $cgi->h1('Create');
	
	# branch according to the input
	if (! $cgi->param('button')) {
		
		# build the form
		$html .= $cgi->p('Use this form to create a subject.');
		$html .= $cgi->start_form(-method => 'post', -action => $cgi->script_name);
		$html .= $cgi->hidden(-name => 'cmd', -value => 'create');
		$html .= table({-border => 0}, Tr({-align => 'left', -valign => 'top'},
						[
							th(['Item', 'Value']),
							td(['Term', $cgi->textfield(-name => 'term')]),
							td(['Note', $cgi->textarea(-name => 'note')]),
							td([''    , $cgi->submit(-name => 'button', -value => 'Create')])
						]
					)
				 );
		$html .= $cgi->endform;
    
    }
    
    else {
    
    	# create an object, fill it, and save
    	my $subject = Musings::Subject->new;
    	$subject->subject_term($cgi->param('term'));
    	$subject->subject_note($cgi->param('note'));
		$subject->commit;
				
		# echo the results
		$html .= $cgi->p('Subject created:');
		$html .= $cgi->ul(li('ID -', $subject->subject_id),
		                  li('Term - ', $subject->subject_term),
		                  li('Note - ', $subject->subject_note)
		                 );
    
    }
    
}


sub find {

	# initialize the output
	$html  = $cgi->h1('All subjects');
	$html .= $cgi->p('This is a list of all the subjects:');
	
	# get all the subjects, build a list, and display it
	my @subjects = Musings::Subject->get_subjects(sort => 'name');
	my $items;
	foreach (@subjects) { $items .= $cgi->li($_->subject_term, ' (' . $_->subject_id . ') - ', $_->subject_note) }
	$html .= $cgi->ul($items);
	
}


sub edit {

	# initialize the output and a button
	$html = $cgi->h1('Edit subjects');
	my $submit .= $cgi->submit(-name => 'button', -value => 'Edit');
	
	# branch according to the input
	if (! $cgi->param('button')) {
	
		# create a hash of subjects; needs to be sorted
		my @subjects = Musings::Subject->get_subjects(sort => 'name');
		my %subjects;
		foreach (@subjects) { $subjects{$_->subject_id} = $_->subject_term }
	
		# display a form
		$html .= $cgi->p('Select a subject to edit');
		$html .= $cgi->start_form(-method => 'post', -action => $cgi->script_name);
		$html .= $cgi->hidden(-name => 'cmd', -value => 'edit');
		$html .= $cgi->popup_menu(-name => 'id', -values => \%subjects);
		$html .= $submit;			 
		$html .= $cgi->endform;

	}
	
	elsif (! $cgi->param('name') || ! $cgi->param('note')) {
	
    	# create an object based on the input, and create form parts
    	my $subject = Musings::Subject->new(id => $cgi->param('id'));
    	
		# display an edit form
		$html .= $cgi->p('Use this form to edit a subject.');
		$html .= $cgi->start_form(-method => 'post', -action => $cgi->script_name);
		$html .= $cgi->hidden(-name => 'cmd', -value => 'edit');
		$html .= $cgi->hidden(-name => 'id', -value => $subject->subject_id);
		$html .= table({-border => 0},
					Tr({-align => 'left', -valign => 'top'},
						[
							th(['Item', 'Value']),
							td(['ID'  , $subject->subject_id]),
							td(['Term', $cgi->textfield(-name => 'name', -value => $subject->subject_term)]),
							td(['Note', $cgi->textarea(-name => 'note', -value => $subject->subject_note)]),
							td([''    , $submit])
						]
					)
				 );
		$html .= $cgi->endform;
    
    }
    
	else {

		# create and object, fill it, and save
		my $subject = Musings::Subject->new(id => $cgi->param('id'));
		$subject->subject_term($cgi->param('name'));
		$subject->subject_note($cgi->param('note'));
		$subject->commit;
		
		# echo the result
		$html .= $cgi->p('Subject updated.');
		$html .= $cgi->p('ID:', $subject->subject_id, '<br />Term:', $subject->subject_term, '<br />Note:' , $subject->subject_note);
    
    }

}


sub delete {

	# initialize the output
	$html = $cgi->h1('Delete subjects');
	
	# branch according to the input
	if (! $cgi->param('button')) {
	
		# build of hash of all subjects; needs to be sorted
		my @subjects = Musings::Subject->get_subjects(sort => 'name');
		my %subjects;
		foreach (@subjects) { $subjects{$_->subject_id} = $_->subject_term }

		# display a pop-up list of subjects
		$html .= $cgi->p('Select a subject to delete:');
		$html .= $cgi->start_form(-method => 'post', -action => $cgi->script_name);
		$html .= $cgi->hidden(-name => 'cmd', -value => 'delete');
		$html .= $cgi->popup_menu(-name => 'id', -values => \%subjects);
		$html .= $cgi->submit(-name => 'button', -value => 'delete', -label => 'Delete');		 
		$html .= $cgi->endform;

	}
	
	elsif ($cgi->param('button') eq 'Delete') {
    
    	# create an object based on input
    	my $subject = Musings::Subject->new(id => $cgi->param('id'));
    	
		# display a confirmation
		$html .= $cgi->p('Are you sure you want to delete the subject named <b>' . $subject->subject_term . '</b>?');
		$html .= $cgi->start_form(-method => 'post', -action => $cgi->script_name);
		$html .= $cgi->hidden(-name => 'cmd', -value => 'delete');
		$html .= $cgi->hidden(-name => 'id', -value => $subject->subject_id);
		$html .= $cgi->submit(-name => 'button', -value => 'yes', -label => 'Yes');
		$html .= ' ';
		$html .= $cgi->submit(-name => 'button', -value => 'no', -label => 'No');		 
		$html .= $cgi->endform;
    
    }
    
    elsif ($cgi->param('button') eq 'Yes') {
    
    	# delete the subject; do the work and echo the result
    	my $subject = Musings::Subject->new(id => $cgi->param('id'));
    	$subject->delete;
    	$html .= $cgi->p('The subject ' . $subject->subject_term . ' has been deleted.');
    
    }
    
    elsif ($cgi->param('button') eq 'No') {
    
    	# abort
    	my $subject = Musings::Subject->new(id => $cgi->param('id'));
    	$html .= $cgi->p('The subject ' . $subject->subject_term . ' has <b>not</b> been deleted.');

    }
    
}


sub gracefulExit {

	# output the 'magic line', a standard header, the content, and a standard footer, then done
	print $cgi->header;
	print &header;
	print $html;
	print &footer;
	exit;

}


sub header {

	# get the value of this script
	my $script = $cgi->script_name;
	
	# return a standard html page; notice the stylesheet
	return <<EOH;
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<title>Manage subjects</title>
		<link rel='stylesheet' href='style.css' type='text/css' />
	</head>
	<body>
		<div id="navcontainer">
			<ul id="navlist">
				<li><a href="home.cgi">Home</a></li>
				<li><a href="authors.cgi">Authors</a></li>
				<li><a href="subjects.cgi" id="current">Subjects</a></li>
				<li><a href="templates.cgi">Templates</a></li>
				<li><a href="stylesheets.cgi">Stylesheets</a></li>
				<li><a href="articles.cgi">Articles</a></li>
			</ul>
		</div>
	
		<div class='menu'>
			<p><b><a href="$script">Manage subjects</a></b></p>
			<a href="$script?cmd=create">Create</a><br />
			<a href="$script?cmd=find">Find all</a><br />
			<a href="$script?cmd=edit">Edit</a><br />
			<a href="$script?cmd=delete">Delete</a><br />
			<br />
		</div>
		
		<div class='content'>
EOH

}
