use Test::More tests => 16;
use strict;


# use the module
use_ok('Musings::Author');


# create a facet object
my $author = Musings::Author->new();
isa_ok($author, "Musings::Author");


# first name
$author->first_name('Eric');
is($author->first_name(), 'Eric', 'set first_name()');


# middle name
$author->middle_name('Lease');
is($author->middle_name(), 'Lease', 'set middle_name()');


# last name
$author->last_name('Morgan');
is($author->last_name(), 'Morgan', 'set name()');


# email
$author->email('eric_morgan@infomotions.com');
is($author->email(), 'eric_morgan@infomotions.com', 'set email()');


# url
$author->url('http://infomotions.com/');
is($author->url(), 'http://infomotions.com/', 'set url()');


# commit
is($author->commit(), '1', 'commit()');


# author_id
my $id = $author->author_id();
like ($id, qr/^\d+$/, 'get author_id()');


# get record based on an id
$author = Musings::Author->new(id => $id);
is ($author->first_name(), 'Eric', 'get first_name() matches based on id');
is ($author->middle_name(), 'Lease', 'get middle_name() matches based on id');
is ($author->last_name(), 'Morgan', 'get last_name() matches based on id');
is ($author->email(), 'eric_morgan@infomotions.com', 'get email() matches based on id');
is ($author->url(), 'http://infomotions.com/', 'get url() matches based on id');


# update a facet record
$author->first_name('Mary');
$author->middle_name('Grey');
$author->last_name('Reid');
$author->email('mgrmorgan@infomotions.com');
$author->url('');
$author->commit();
$author = Musings::Author->new(id => $id);
is ($author->first_name(), 'Mary', 'commit() update');


# delete
is($author->delete(), '1', 'delete()');

